from axelrod.action import Action, actions_to_str

from axelrod.player import Player

from axelrod.strategy_transformers import (
    FinalTransformer,
    TrackHistoryTransformer,
)

C, D = Action.C, Action.D

class RandomTitForTat(Player):
    """
    A player starts by cooperating and then follows by copying its
    opponent (tit for tat style).  From then on the player
    will switch between copying its opponent and randomly
    responding every other iteration.

    Name:

    - Random TitForTat: Original name by Zachary M. Taylor
    """

    # These are various properties for the strategy
    name = "Random Tit for Tat"
    classifier = {
        "memory_depth": 1,
        "stochastic": True,
        "long_run_time": False,
        "inspects_source": False,
        "manipulates_source": False,
        "manipulates_state": False,
    }

    def __init__(self, p: float = 0.5) -> None:
        """
        Parameters
        ----------
        p, float
            The probability to cooperate
        """
        super().__init__()
        self.p = p
        self.act_random = False
        if p in [0, 1]:
            self.classifier["stochastic"] = False

    def strategy(self, opponent: Player) -> Action:
        """This is the actual strategy"""
        if not self.history:
            return C

        if self.act_random:
            self.act_random = False
            try:
                return self._random.random_choice(self.p)
            except AttributeError:
                return D if self.p == 0 else C

        self.act_random = True
        return opponent.history[-1]